package com.xunlei.niux.mobilegame.virtual;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.webkit.WebView;

import com.xovs.common.base.XLLog;
import com.xunlei.niux.BuildConfig;
import com.xunlei.niux.mobilegame.sdk.handler.NiuxCrashHandler;
import com.xunlei.niux.mobilegame.sdk.platform.IAppHandler;
import com.xunlei.niux.mobilegame.sdk.platform.NiuxMobileGame;
import com.xunlei.niux.mobilegame.sdk.platform.NiuxMobileGameListener;
import com.xunlei.niux.mobilegame.sdk.platform.NxConfig;
import com.xunlei.niux.mobilegame.sdk.util.ToastUtils;

/**
 * Created by jamesjxin on 14-12-9.
 */
public class Application extends android.app.Application {

    public static final String ClientId = "YrJ72qsy_5P0I5rn";
    public static final String ClientSecret = "i0QbLPHREeyEisa3ireNJA";
    public static final String HostMain = "https://xluser-ssl.xunlei.com";

    public static final String ClientIdTest = "XgsEHW-x2ZgbKCFN";
    public static final String ClientSecretTest = "XgsEHYAyD4jRu0bdvDLCrctXmC0";
    public static final String HostTest = "https://2rvk4e3gkdnl7u1kl0k.xbase.xyz";

    @Override
    public void onCreate() {
        super.onCreate();
        new Handler(Looper.getMainLooper()).postDelayed(() -> {
            initGame();
        }, 0);
    }

    private void initGame() {
        // 如果游戏方已实现UncaughtExceptionHandler，
        // 则在其逻辑中添加上报niux平台的方法:
        // CrashReportService.reportCrash(errContent);
        // 否则，建议直接调用该方法
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            WebView.setWebContentsDebuggingEnabled(true);
        }

        NiuxCrashHandler.getInstance().init(this);
        String appid = "596af11482f747c2a72ac8463b2f8000";
        String bizid = "1202003315"; // 1202003638
        String gameID = "cap7kmbrc8k501l3997g";
        String lGid = getSharedPreferences("test", Context.MODE_PRIVATE).getString("gameid", null);
        if (!TextUtils.isEmpty(lGid)) {
            gameID = lGid;
        }
        String gameName = "niux";

        NxConfig.Builder nxConfig = new NxConfig.Builder(appid, bizid, gameID);
        nxConfig.gameName(gameName).coopId("c7ii2cbrc8k070ku4f20").coopName("海南名光科技有限公司");
        //线上
        nxConfig.clientId(ClientId);
        nxConfig.clintSecret(ClientSecret);

        nxConfig.schemeCallback("niuxsdkdemo");//对应Manifest中XLAuthBackActivity的scheme
        nxConfig.xlPayKey("d46d9845f3c39472d68248426b37a323");
        nxConfig.GDTUserActionSetId("1211326411");
        nxConfig.GDTAppSecretKey("896b9d5d87d2e3c70dabd6d09ab48061");
        nxConfig.byteDanceAppId("709726");

        if (BuildConfig.DEBUG) {
            XLLog.setDebugMode(true);
        }

        NiuxMobileGame.getInstance().initMobileGame(getApplicationContext(), "", nxConfig, new SDKListener(this), new IAppHandler() {
            @Override
            public void onAppDeal(int type, String param) {
                String text = type + ":" + param;
                XLLog.d("IAppHandler", "onAppDeal " + text);
                switch (type) {
                    case Type.GoLogin:
                        //跳至登录页或登出
                        break;
                    case Type.DoToast:
                        //游戏方自己的toast
                        ToastUtils.longToast(getApplicationContext(), param);
                        break;
                    default:
                        break;
                }

            }
        });
    }

    @Override
    public void onTerminate() {
        super.onTerminate();
        NiuxMobileGame.getInstance().unInit();
    }

}
