package com.xunlei.niux.mobilegame.virtual;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

import androidx.annotation.Nullable;

import com.xovs.common.auth.base.SendAuth;
import com.xunlei.niux.R;
import com.xunlei.niux.mobilegame.sdk.BuildConfig;
import com.xunlei.niux.mobilegame.sdk.pay.GamePayInfo;
import com.xunlei.niux.mobilegame.sdk.platform.NiuxMobileGame;
import com.xunlei.niux.mobilegame.sdk.platform.NiuxMobileGameLoginListener;
import com.xunlei.niux.mobilegame.sdk.services.LoginService;
import com.xunlei.niux.mobilegame.sdk.web.H5GameActivity;
import com.xunlei.niux.mobilegame.sdk.util.DialogUtils;
import com.xunlei.niux.mobilegame.sdk.util.ToastUtils;
import com.xunlei.niux.mobilegame.sdk.vo.LoginUser;
import com.xunlei.niux.mobilegame.sdk.web.XLWebViewBaseActivity;

import org.json.JSONException;
import org.json.JSONObject;

import java.lang.reflect.Field;

public class DemoActivity extends Activity implements OnClickListener {
    private static final String TAG = DemoActivity.class.getSimpleName();
    private Button mButtonLogin;
    private Button mButtonChargeCenterMoney;
    private Button mButtonUserStatus;
    private Button mButtonCreateRole;
    private Button btn_isauth;
    private EditText edit_text_user_name1;
    private EditText mPrudcutIdEt;
    private EditText mMoneyEt;
    private EditText mAmmountEt;
    private EditText mGameIDEt;

    private TextView mTextView;

    private int mIndex = 1;


    boolean online = true;
    private NiuxMobileGameLoginListener mListener = new NiuxMobileGameLoginListener() {
        @Override
        public void onUserLoginResult(boolean isSuccess, int errorCode, String errorDesc, LoginUser loginUser) {
            Log.d(TAG, "onUserLoginResult: " + isSuccess + " errorCode: " + errorCode + " errorDesc: " + errorDesc);
            loginUser.userName = "游戏SDK测试";//最好传登录者的昵称
            if (isSuccess) {
                mButtonLogin.post(new Runnable() {
                    @Override
                    public void run() {
                        ToastUtils.longToast(DemoActivity.this, "登录成功");
                        edit_text_user_name1.setText(loginUser.userName);
                    }
                });
//                    NiuxMobileGame.getInstance().tryShowFloatView(DemoActivity.this);
            }
            NiuxMobileGame.getInstance().onLoginResult(isSuccess, loginUser, false);
        }

        @Override
        public void onUserLogout() {
            Log.d(TAG, " user logout ");
        }
    };

    @Override
    public void onCreate(Bundle savedInstanceState) {
        Log.d(TAG, "onCreate()");
        super.onCreate(savedInstanceState);
        initUI();

        online = getSharedPreferences("test", Context.MODE_PRIVATE).getBoolean("online_env", true);

        //测试用https://2rvk4e3gkdnl7u1kl0k.xbase.xyz线上：https://xluser-ssl.xunlei.com，游戏方忽略
        if (online) {
//            Config config = new Config(DemoApplication.HostMain, DemoApplication.ClientId, DemoApplication.ClientSecret, null);
//            oauth2Client = new Oauth2Client(config);
//            mAuthApis = AuthApis.getInstance(oauth2Client);
            LoginService.getInstance().setHost(Application.HostMain);
        } else {
//            Config config = new Config(DemoApplication.HostTest, DemoApplication.ClientIdTest, DemoApplication.ClientSecretTest, null);
//            oauth2Client = new Oauth2Client(config);
//            mAuthApis = AuthApis.getInstance(oauth2Client);
            LoginService.getInstance().setHost(Application.HostTest);
        }
        if (online) {
            ((Button) findViewById(R.id.switch_env)).setText("当前正式环境（切换）");
        } else {
            ((Button) findViewById(R.id.switch_env)).setText("当前测试环境（切换）");
        }
        mTextView.setText("demo版本：" + NiuxMobileGame.getInstance().getClientVersion());
        mTextView.append("\nSDK版本：" + BuildConfig.VERSION_NAME);
        mTextView.append("\n版本号：" + BuildConfig.VERSION_CODE);
    }

    private void initUI() {
        setContentView(R.layout.main);

        this.mButtonLogin = (Button) this.findViewById(R.id.login);
        this.mButtonLogin.setOnClickListener(this);

        this.mButtonChargeCenterMoney = (Button) this.findViewById(R.id.chargecenter_money);
        this.mButtonChargeCenterMoney.setOnClickListener(this);

        this.mButtonUserStatus = (Button) this.findViewById(R.id.userstatus);
        this.mButtonUserStatus.setOnClickListener(this);

        this.mButtonCreateRole = (Button) this.findViewById(R.id.create_role);
        this.mButtonCreateRole.setOnClickListener(this);

        findViewById(R.id.quit_game).setOnClickListener(this);

        edit_text_user_name1 = findViewById(R.id.edit_text_user_name1);
        edit_text_user_name1.setCursorVisible(false);
        mPrudcutIdEt = findViewById(R.id.et_productid);
        mAmmountEt = findViewById(R.id.et_ammount);
        mGameIDEt = findViewById(R.id.et_gameid);
        mMoneyEt = findViewById(R.id.et_money);

        btn_isauth = findViewById(R.id.btn_isauth);
        btn_isauth.setOnClickListener(this);
        findViewById(R.id.switch_env).setOnClickListener(this);
        findViewById(R.id.btn_setgameid).setOnClickListener(this);

        mTextView = findViewById(R.id.tv_version);

    }

    @Override
    protected void onDestroy() {
        Log.d(TAG, "onDestroy()");
        super.onDestroy();
        System.exit(0);
    }

    @Override
    public void onBackPressed() {
        Log.d(TAG, "onBackPressed()");
        if (NiuxMobileGame.getInstance().showExitDialog(this)) {
            // 已弹框
        } else {
            NiuxMobileGame.getInstance().quitGame("myChannel", userId);
            super.onBackPressed();
        }

    }

    String userId = "";
    boolean copied = true;

    @Override
    public void onClick(View v) {
        //若运行不了，可自行删除此行
        switch (v.getId()) {
            case R.id.login:
                if (NiuxMobileGame.getInstance().isLogin()) {
                    ToastUtils.longToast(DemoActivity.this, "你已经登录了");
                    return;
                }
                showlogin();
                break;
            case R.id.chargecenter_money:
//                NiuxMobileGame.getInstance().setGameId(mGameIDEt.getText().toString());
                if (!NiuxMobileGame.getInstance().isLogin()) {
                    ToastUtils.longToast(DemoActivity.this, "请先登录");
                    return;
                }
                String productId = mPrudcutIdEt.getText().toString();
                String money = mMoneyEt.getText().toString();
                String ammount = mAmmountEt.getText().toString();
                if (!TextUtils.isDigitsOnly(ammount)) {
                    ToastUtils.shortToast(DemoActivity.this, "数量不正确");
                    return;
                }
                if (TextUtils.isEmpty(money)) {
                    ToastUtils.shortToast(DemoActivity.this, "金额不正确");
                    return;
                }
                String ext = "";

                try {
                    JSONObject jsonObject = null;
                    jsonObject = new JSONObject();
                    jsonObject.put("productName", "手游测试充值");
                    ext = jsonObject.toString();
                } catch (JSONException e) {
                    e.printStackTrace();
                }

                GamePayInfo.PaySignExt paySignExt = new GamePayInfo.PaySignExt();
                // TODO: 2020/1/9 paySignExt如果有协议好的加密算法则游戏方补充上，没有则忽略，传空即可

                //通过NiuxMobileGameListener.onChargeFinish返回，首个参数result参考通过NiuxMobileGameListener.PayResult
                NiuxMobileGame.getInstance().chargePay(DemoActivity.this, productId,
                        Integer.parseInt(ammount), Float.parseFloat(money), ext, paySignExt);
                break;
            case R.id.userstatus:
                final LoginUser user = NiuxMobileGame.getInstance().getLoginUser();
                if (user != null) {
                    String separator = System.getProperty("line.separator");
                    StringBuffer userinfo = new StringBuffer();
                    userinfo.append("userName : ").append(user.userName).append(separator);
                    userinfo.append("userId : ").append(user.userId).append(" expirein:").append(user.expiresIn).append(separator);
                    userinfo.append("accesToken : ").append(user.accessToken).append(separator);
                    userinfo.append("refreshToken:").append(user.refreshToken).append(separator);

                    DialogUtils.confirm(this, null, userinfo.toString(), "确定", "复制", new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                        }
                    }, new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            if (copied) {
                                ClipData clipData = ClipData.newPlainText("", user.accessToken);
                                ((ClipboardManager) DemoActivity.this.getSystemService(Context.CLIPBOARD_SERVICE)).setPrimaryClip(clipData);
                                ToastUtils.shortToast(DemoActivity.this, "已复制token");
                            } else {
                                ClipData clipData = ClipData.newPlainText("", user.userId);
                                ((ClipboardManager) DemoActivity.this.getSystemService(Context.CLIPBOARD_SERVICE)).setPrimaryClip(clipData);
                                ToastUtils.shortToast(DemoActivity.this, "已复制userId");
                            }
                            copied = !copied;
                        }
                    }).show();

                }
                break;
            case R.id.create_role:
                //发版测试前使用，正式发版去掉
                if (!LoginService.getInstance().isLogin()) {
                    ToastUtils.shortToast(DemoActivity.this, "未登录");
                    break;
                }


                // 创角上报
                NiuxMobileGame.getInstance().actionReport("heyGuy", "justTest", "myChannel", 1);

                // 心跳上报
                NiuxMobileGame.getInstance().enterGame("heyGuy", "justTest", "myChannel");

                ToastUtils.shortToast(DemoActivity.this, "游戏角色创建成功");
                edit_text_user_name1.setText("-角色" + mIndex++);
                break;
            case R.id.quit_game:
                NiuxMobileGame.getInstance().onLogout();
                mIndex = 1;
                ToastUtils.shortToast(DemoActivity.this, "已退出登录");
                edit_text_user_name1.setText("");
//                if (oauth2Client != null) {
//                    oauth2Client.setCredentials(null);
//                }
                NiuxMobileGame.getInstance().tryDestroyFloatView(this);
                break;
            case R.id.btn_isauth:
                NiuxMobileGame.getInstance().requestRealCertification();
                break;
            case R.id.switch_env:
                if (LoginService.getInstance().isLogin()) {
                    ToastUtils.shortToast(DemoActivity.this, "已登录账号");
                    break;
                }
                getSharedPreferences("test", Context.MODE_PRIVATE).edit().putBoolean("online_env", !online).apply();
                ToastUtils.longToast(DemoActivity.this, "重启应用中");
                mButtonLogin.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        restartApp();
                    }
                }, 1500);
                break;
            case R.id.btn_setgameid:
                getSharedPreferences("test", Context.MODE_PRIVATE).edit().putString("gameid", mGameIDEt.getText().toString()).apply();
                mButtonLogin.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        restartApp();
                    }
                }, 1500);
                break;
            default:
                break;
        }
    }

    private void showlogin() {
        if (NiuxMobileGame.getInstance().isLogin()) {
            return;
        }
        final SendAuth.Req req = new SendAuth.Req();
        if (getSharedPreferences("test", Context.MODE_PRIVATE).getBoolean("online_env", true)) {
            //此Demo的user是很高权限，一般游戏方传的应该是“user profile verified offline” verified实名认证时用，offline 刷新token用，需要一起配置好
            req.scope = "user verified offline check query report";
        } else {
            //忽略，游戏方用“user profile verified offline”即可 verified实名认证时用，offline 刷新token用需要一起配置好
            req.scope = "profile verified offline check query report";//此测试的user是很高权限，一般游戏方传的应该是“user profile verified offline”
        }
        req.state = "xlkdemo_code";//游戏方自定义，response返回的state同此值一致
        req.responseType = "code";//固定code
        NiuxMobileGame.getInstance().showLogin(DemoActivity.this, req, mListener);
    }


    /**
     * 重新启动App -> 杀进程,会短暂黑屏,启动慢
     */
    public void restartApp() {
        //启动页
        Intent intent = new Intent(getApplicationContext(), DemoActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        getApplicationContext().startActivity(intent);
        android.os.Process.killProcess(android.os.Process.myPid());
    }
}
