package com.xunlei.niux.mobilegame.virtual;

import android.app.Activity;
import android.content.Context;
import android.os.Process;
import android.util.Log;

import com.xunlei.niux.mobilegame.sdk.constants.InitResult;
import com.xunlei.niux.mobilegame.sdk.platform.AuthorizationData;
import com.xunlei.niux.mobilegame.sdk.platform.NiuxMobileGame;
import com.xunlei.niux.mobilegame.sdk.platform.NiuxMobileGameListener;
import com.xunlei.niux.mobilegame.sdk.util.ToastUtils;

/**
 * Created by jamesjxin on 14-5-5.
 * 游戏方应自行实现该回调通知接口
 */
public class SDKListener extends NiuxMobileGameListener {
    private static final String TAG = SDKListener.class.getSimpleName();
    private Context activity;

    public SDKListener(Context activity) {
        this.activity = activity;
    }

    @Override
    public void onSDKInitialized(int result) {
        super.onSDKInitialized(result);

        Log.d(TAG, "onSDKInitialized result = " + result);

        switch (result) {
            case InitResult.Success: //初始化成功
                Log.d(TAG, InitResult.getResultMessage(result));
                break;
            case InitResult.Missing_Parameter:
            case InitResult.Oauth_Failed:
            case InitResult.Network_Failed:

                ToastUtils.longToast(activity, InitResult.getResultMessage(result));

                Log.d(TAG, InitResult.getResultMessage(result));
        }
    }

    // 此方法只是提示游戏方用户充值操作已经完成
    // 具体游戏币发放的通知将由联运的充值服务器通知，游戏方应自己去查询发货到账了没
    @Override
    public void onChargeFinish(int result, float money, String procductId, String orderid) {
        Log.d(TAG, "onChargeFinish result = " + result + ", money = " + money + ", procductId = " + procductId + ", orderid = " + orderid);
        //do check the bill
    }

    @Override
    public void onTokenExpired(String accessToken) {
        super.onTokenExpired(accessToken);
        Log.d(TAG, "onTokenExpired 过期" + accessToken);
        // TODO: 2019/12/3 让用户重新登录？
//        LoginUser loginUser = new LoginUser();
//        loginUser.accessToken = "new token";
//        NiuxMobileGame.getInstance().onLoginResult(true, loginUser, false);

    }

    @Override
    public void onAuthorizationReal(int isAuth, int age, AuthorizationData data) {
        Log.d(TAG, "onAuthorizationReal isAuth=" + isAuth + " ;age=" + age);
        String toast = "查询认证：" + isAuth + ";" + age + ";";
        if (data != null) {
            toast += data.age;
            Log.d(TAG, "onAuthorizationReal AuthorizationData.age=" + data.age);
        }

        //test
        ToastUtils.longToast(activity, toast);
    }

    //游戏方实现的退出游戏应用
    @Override
    public void onExitGame(Context context) {
        if (NiuxMobileGame.getInstance().getLoginUser() != null) {
            NiuxMobileGame.getInstance().quitGame("", NiuxMobileGame.getInstance().getLoginUser().userId);
        }
        if (context instanceof Activity) {
            ((Activity) context).finish();
            Process.killProcess(Process.myPid());
        } else {
            Process.killProcess(Process.myPid());
            System.exit(0);
        }
    }
}
